; TeddyWareZ MSX Z80 source file.
;
; Prog: TeddyWareZ boot!
; Code: d-fader^TwZ.
; Date: august 19, 1999
;
; cmnt: none.
;
; coded in Chaos Assembler 2.0
;
; (C) 1999 TeddyWareZ!

#define	ClearFCB						  ld hl,fcb_
#defcont								\ ld de,fcb_+1
#defcont								\ ld bc,EndFcb_-fcb_-1
#defcont								\ ld (hl),0
#defcont								\ ldir

#define	SetVW(pa,offset)					  ld a,pa
#defcont								\ ld hl,offset
#defcont								\ call SetVramWrite


#include "macro's.asm"
; #include "sb2rmacr.asm"

	.org $d300

start_program:
	di								; disable interrupts

	in a,($a8)							; get primair slot selections

	ld b,a							; in b

	ld (primair),a						; save primair slot selections

	ld a,($ffff)
	cpl								; inverse (1's compliment)
	ld (secondare),a						; save secondare slot selections

	ld a,($f342)		
	and %00000011						; get primair selection of page 1 (RAM)
	sla a
	sla a								; rotate it to primair selection.
	ld c,a							; for save keepin'

	ld a,b							; get primair selection again.
	and %11110011						; get rid of primair selection of page 1

	or c								; get our primair selection in it..

	out ($a8),a							; out it!

	ld a,(secondare)						; get secondare slot selection
	and %11110011						; get rid of secondare slot sel. of page 1
	ld b,a							; save it

	ld a,($f342)
	and %00001100						; get secondare selection (page 1)..
	or b								; get our secondare selection in it!
	ld ($ffff),a						; out it!
	
	ei

	Color(15,0,0)

	ld a,80							; width 80
	ld ($f3ae),a						; 

	xor a								; disable key click
	ld ($f3db),a						;

	call erafnk							; erase function keys

	xor a
	call chgmod

	call ShowAllShit

	ld a,1
	out ($fe),a

	ld a,2
	out ($fd),a

	ld a,7
	call chgmod

	SetPalette(BlackPalette)

	ld de,fcb_
	bdos(open)

	ld de,$4000
	bdos(set_dma)

	ld hl,1
	ld (rec_size),hl

	ld hl,124*256
	ld de,fcb_
	bdos(rnd_br)

	bdos(close)

	ld a,0
	ld de,$2c00
	ld hl,$4000
	ld bc,124*256
	call CopyRamVram

	ld de,BlackPalette
	ld hl,LogoPalette
	call d_fader

	ClearFCB

	ld hl,BlafLoadScrn
	ld de,BlafFileName
	ld bc,11
	ldir

	ld de,fcb_
	bdos(open)

	ld de,$4000
	bdos(set_dma)

	ld hl,1
	ld (rec_size),hl

	ld hl,(file_size)
	ld de,fcb_
	bdos(rnd_br)

	bdos(close)

	ClearFCB

	ld hl,BlafMainName
	ld de,BlafFileName
	ld bc,11
	ldir

	ld de,fcb_
	bdos(open)

	ld de,$c000-7
	bdos(set_dma)

	ld hl,1
	ld (rec_size),hl

	ld hl,(file_size)
	ld de,fcb_
	bdos(rnd_br)

	bdos(close)

	ld b,50*3
wait:
	ei
	halt
	djnz wait

	ld de,LogoPalette
	ld hl,BlackPalette
	call d_fader

EndCode:
	ld a,(Primair)
	out ($a8),a

	ld a,(Secondare)
	ld ($ffff),a

	jp $c000

CopyRamVram:
; routine : Copy part of RAM to VRAM.
; in      : A - VRAM page, DE - Offset VRAM (destination), HL - Source pointer, BC - Number of
;		Bytes...
; out     : none.
; cmnt    : none.

	push af

	ld a,c
	ld (CRV.LastOut),a

	pop af

	push hl

	ex de,hl

	call SetVramWrite

	pop hl

	ld a,b
	or a
	jp z,CRV.Loop1Done

	ld d,b
	ld c,$98

CopyRamVramLoop1:
	ld b,$00
	otir

	dec d
	jr nz,CopyRamVramLoop1

CRV.Loop1Done:
	ld a,(CRV.LastOut)
	or a
	ret z

	ld b,a

	ld c,$98
	otir

	ret

CRV.LastOut:
	.db 0


SetVramRead:
; routine : Set Vram Pointer in write mode.
; in      : A - page, HL - offset
; out     : none.
; cmnt    : none.

	di

	out ($99),a					; out page to register #14 of the VDP
	ld a,14+128					;
	out ($99),a					;

	ld a,l					; Get LSB of offset
	out ($99),a					; out to VDP

	ld a,h					; Get MSB of offset
	out ($99),a					; out to VDP

	ei

	ret

SetVramWrite:
; routine : Set Vram Pointer in write mode.
; in      : A - page, HL - offset
; out     : none.
; cmnt    : none.

	di

	out ($99),a					; out page to register #14 of the VDP
	ld a,14+128					;
	out ($99),a					;

	ld a,l					; Get LSB of offset
	out ($99),a					; out to VDP

	ld a,h					; Get MSB of offset

	and $3f					; clear last two bits
	or $40					; set bit 6 (write)

	out ($99),a					; out to VDP

	ei

	ret

Fcb_:
	.db    0
BlafFilename:
	.db    "BLAF_NT 021"
clear_fcb:
	.db    0,0
rec_size:
	.db    0,0
file_size:
	.db    0,0,0,0,0,0,0,0

	.db    0,0,0,0,0,0,0,0

	.db    0,0,0,0
	.db    0

	.dw 0,0
EndFcb_:


BlafMainName:
	.db "BLAF_NT 000"
BlafLoadScrn:
	.db "BLAF_NT 005"


Primair:
	.db 0
Secondare:
	.db 0

CheckRam:
	ld b,0
CheckRam.1:
	ld a,b
	out ($fe),a

	xor a
	ld ($8000),a

	djnz CheckRam.1

	ld bc,0
CheckRam.2:
	ld a,b
	out ($fe),a

	ld a,($8000)

	cp 1
	jp z,CheckRam.done

	ld a,1
	ld ($8000),a

	inc c

	djnz CheckRam.2

CheckRam.Done:
	ld a,c
	ld (RamBanks),a

	ret

RamBanks:
	.db 0

CheckVRam:
	ld b,0
CheckVRam.1:
	ld a,b
	ld hl,0
	call SetVramWrite

	xor a
	out ($98),a

	djnz CheckVRam.1

	ld bc,0
CheckVRam.2:
	ld a,b
	ld hl,0
	call SetVramRead

	in a,($98)

	cp 1
	jp z,CheckVRam.done

	ld a,b
	ld hl,0
	call SetVRamWrite

	ld a,1
	out ($98),a

	inc c

	djnz CheckVRam.2

CheckVRam.Done:
	ld a,c
	ld (VRamBanks),a

	ret

VRamBanks:
	.db 0

ShowRamVram:
	push bc

	ld hl,RamInCPU
	ld de,RamInCPU+1
	ld bc,3
	ld (hl),32
	ldir

	pop bc

	ld hl,0
	ld de,16
	ld ix,RamInCPU
ShowRamVram.1:
	add hl,de

	djnz ShowRamVram.1

	ld de,1000
	call Calc16Dec
	
	cp 48
	jp nz,ShowRamVramOk

	ld a,32
ShowRamVramOk:
	ld (ix),a

	ld de,100
	call Calc16Dec
	
	ld (ix+1),a

	ld de,10
	call Calc16Dec
	
	ld (ix+2),a

	ld de,1
	call Calc16Dec
	
	ld (ix+3),a

	ld hl,RamInCPU
	ld bc,$0598
	otir

	ret


Calc16Dec:
	ld c,-1
Calc16Dec.loop:
	or a
	sbc hl,de

	inc c

	jp nc,Calc16Dec.loop

	add hl,de

	ld a,c

	add a,48

	ret

RamInCPU:
	.text "1234K"

ShowAllShit:
	call CheckDos2

	call disscr

	call CheckVRAM

	xor a
	call cls

	call enascr

	call DoCheckRam
	call DoCheckVram
	call DoCheckSystem
	call ShowRAM
	call ShowVRAM
	call ShowVDP

	call MainLoop

	ret




DoCheckRam:
	SetVW(0,0)

	ld hl,Ram
	ld c,$98
	ld b,RamEnd-Ram
	otir

	call CheckRam

	ld a,(RamBanks)
	or a
	jp z,SystemOk
	cp 7
	jp c,Systemfailed

SystemOk:
	ld hl,Passed
	ld c,$98
	ld b,PassedEnd-Passed
	otir

	ret

DoCheckVRam:
	SetVW(0,80)

	ld hl,VRam
	ld c,$98
	ld b,VRamEnd-VRam
	otir

	ld a,(VRamBanks)
	cp 7
	jp c,Systemfailed

	ld hl,Passed
	ld c,$98
	ld b,PassedEnd-Passed
	otir

	ret

SystemFailed:
	ld hl,Failed
	ld c,$98
	ld b,FailedEnd-Failed
	otir

Sys.1:
	jp Sys.1

DoCheckSystem:
	SetVW(0,3*80)

	ld hl,MSXInfo
	ld c,$98
	ld b,MSXInfoEnd-MSXInfo
	otir

	ld a,($2d)

	ld hl,Msx1System
	ld b,MSX1SystemEnd-MSX1System

	cp 0
	jp z,SystemChosen

	ld hl,Msx2System
	ld b,MSX2SystemEnd-MSX2System

	cp 1
	jp z,SystemChosen

	ld hl,Msx2PlusSystem
	ld b,MSX2PlusSystemEnd-MSX2PlusSystem

	cp 2
	jp z,SystemChosen

	ld hl,MSXTRSystem
	ld b,MSXTrSystemEnd-MSXTrSystem

SystemChosen:
	ld c,$98
	otir

	ld a,($2d)
	cp 0
	jp z,Sys.1

	ret

ShowRam:
	SetVW(0,5*80)

	ld hl,MEMInfo
	ld c,$98
	ld b,MemInfoEnd-MemInfo
	otir

	ld a,(RamBanks)
	ld b,a
	call ShowRamVram

	ret

ShowVRam:
	SetVW(0,6*80)

	ld hl,VMEMInfo
	ld c,$98
	ld b,VMemInfoEnd-VMemInfo
	otir

	ld a,(VRamBanks)
	ld b,a
	call ShowRamVram

	ret

ShowVDP:
	SetVW(0,7*80)

	ld hl,VideoChip
	ld c,$98
	ld b,VideoChipEnd-VideoChip

	otir

	di

	StatReg(1)
	in a,($99)

	push af

	StatReg(0)

	pop af

	ei

	and %00111110

	ld hl,VDPChips

	or a
	jp z,VDPChosen

	ld hl,VDPChips+7
VDPChosen:
	ld bc,$0598
	otir

	ret

DoSlotSearch:
	call SearchSCC

	SetVW(0,9*80)

	ld hl,SlotSearch
	ld c,$98
	ld b,SlotSearchEnd-SlotSearch
	otir

	SetVW(0,10*80)

	ld hl,Slot1
	ld c,$98
	ld b,Slot1End-Slot1
	otir

	ld hl,SCCFound
	ld b,SCCFoundEnd-SCCFound

	ld a,(SCC1)
	or a
	jp nz,Slot1Ok

	ld hl,SCCNotFound
	ld b,SCCNotFoundEnd-SCCNotFound

Slot1Ok:
	ld c,$98
	otir

	SetVW(0,11*80)

	ld hl,Slot2
	ld c,$98
	ld b,Slot2End-Slot2
	otir

	ld hl,SCCFound
	ld b,SCCFoundEnd-SCCFound

	ld a,(SCC2)
	or a
	jp nz,Slot2Ok

	ld hl,SCCNotFound
	ld b,SCCNotFoundEnd-SCCNotFound

Slot2Ok:
	ld c,$98
	otir

	ret	

MainLoop:
	call DoSlotSearch

	ld c,1
	ld d,0

	ld a,($fbe5)
	bit 1,a
	jp z,ForceMusic

	ld c,0
	ld d,1

	ld a,($fbe5)
	bit 2,a
	jp z,ForceMusic

	ld a,(SCC1)
	or a
	jp nz,DoBootBlaf

	ld a,(SCC2)
	or a
	jp nz,DoBootBlaf

	SetVW(0,13*80)

	ld hl,NotOk
	ld c,$98
	ld b,NotOkEnd-NotOk
	otir

	jp MainLoop

RealSCC:
	.db 0

DoBootBlaf:
	SetVW(0,13*80)

	ld hl,AllOk
	ld c,$98
	ld b,AllOkEnd-AllOk
	otir
	
	ld b,150
DoBootBlafWait:
	ei
	halt

	djnz DoBootBlafWait

	ld c,%00010000

	ld a,(SCC1)
	or a
	jp nz,DBB.Done

	sla c

DBB.Done:
	ld a,c
	ld ($f7f8),a

	ret

ForceMusic:
	ld a,c
	ld (SCC1),a

	ld a,d
	ld (SCC2),a

	jp DoBootBlaf

SearchScc:
	xor a
	ld (SCC1),a
	ld (SCC2),a

	in a,($a8)								; get primair page selections

	push af								; save primair page selections

	and %11001111							; remove page 2 ($8000-$bfff)

	push af								; save that primair selection

	add a,%00010000							; first test in port 1
	call check								; test

	ld (SCC1),a

	pop af								; get primair selection back

	push af

	add a,%00100000							; then test in port 2 (if none fnd.)
	call check								; test

	ld (SCC2),a

	pop af

	pop af								; get original prim. selections back

	out ($a8),a								; out that!

	ret

SCC1:
	.db 0
SCC2:
	.db 0

check:
	out ($a8),a							; check port
	ld c,a							; save port before

	ld a,($9000)						; get address 9000
	ld d,a							; set in d

	xor a								; 0 to address 9000
	ld ($9000),a

	ld a,($9000)						; if it now still is 0 then no SCC is fnd.
	or a
	jr z,noscc							; till here

	ld b,a							; set that <> 0 in b
	xor $ff							; inverse a

	ld ($9000),a						; inverse a to address 9000
	ld a,($9000)						; get address 9000 again

	cp b								; if it's not b then an SCC is found
	jr nz,sccfnd						; (if address 9000 has the inversed a)

noscc:
	xor a

	ret

sccfnd:
	ld a,1

	ret

scc:
	.db 0




















RAM:
	.text "Minimum 128K RAM...  "
RAMEnd:

VRAM:
	.text "Minimum 128K VRAM... "
VRAMEnd:

Passed:
	.text "Passed!"
PassedEnd:

Failed:
	.text "Failed, system halted!"
FailedEnd:

MSXInfo:
	.text "MSX System : "
MSXInfoEnd:

MSX1System:
	.text "MSX 1, not good enough. mzl!"
MSX1SystemEnd:

MSX2System:
	.text "MSX 2"
MSX2SystemEnd:

MSX2PlusSystem:
	.text "MSX 2+"
MSX2PlusSystemEnd:

MSXTRSystem:
	.text "MSX Turbo R!"
MSXTRSystemEnd:

MEMInfo:
	.text "Total RAM  : "
MEMInfoEnd:

VMEMInfo:
	.text "Total VRAM : "
VMEMInfoEnd:

VideoChip:
	.text "Video Chip : "
VideoChipEnd:

VDPChips:
	.text "V9938   V9958"

SlotSearch:
	.text "Slot search:"
SlotSearchEnd:

Slot1:
	.text "Slot 1     : "
Slot1End:

Slot2:
	.text "Slot 2     : "
Slot2End:

SCCFound:
	.text "Found SCC!"
SCCFoundEnd:

SCCNotFound:
	.text "No SCC..."
SCCNotFoundEnd:

AllOk:
	.text "All Ok! Ready to launch SCC Blaffer NT!                                       "
AllOkEnd:

NotOk:
	.text "No SCC found! Please insert SCC in any slot, or press 1 or 2 to force music..." 
	;      12345678901234567890123456789012345678901234567890123456789012345678901234567890
NotOkEnd:



d_fader:
; routine : The fader... (aka. d-fader)
; in      : DE - Palette to fade from, HL - Palette to fade to.
; out     : none.
; cmnt    : none.

	push hl

	ex de,hl

	ld de,DataPalette
	ld bc,32
	ldir

	pop hl

	ld b,8
d_fader.2:
	push bc
	push hl

	ld ($e000),hl

	ld de,DataPalette

	ld b,16
d_fader.1:
	push bc

	ld a,(de)					; $00
	srl a	
	srl a
	srl a
	srl a
	ld b,a					; $00

	ld a,(hl)					; $77
	srl a
	srl a
	srl a
	srl a						; $07

	cp b						; nc
	jp z,d_fader.NoChange1

	jp c,d_fader.Decrease1

	inc b
	inc b
d_fader.Decrease1:
	dec b
	
d_fader.NoChange1:
	ld a,(de)
	and $0f

	ld c,a

	ld a,(hl)
	and $0f

	cp c
	jp z,d_fader.NoChange2

	jp c,d_fader.Decrease2

	inc c
	inc c
d_fader.Decrease2:
	dec c
d_fader.NoChange2:
	ld a,b
	sla a
	sla a
	sla a
	sla a
	or c

	ld (de),a

	inc de
	inc hl

	ld a,(de)
	ld b,a
	ld a,(hl)
	cp b
	jp z,d_fader.NoChange3

	jp c,d_fader.Decrease3

	inc b
	inc b
d_fader.Decrease3:
	dec b

d_fader.NoChange3:
	ld a,b
	ld (de),a

	inc de
	inc hl

	pop bc

	djnz d_fader.1

	SetPalette(DataPalette)

	ei
	halt
	halt

	pop hl
	pop bc

	djnz d_fader.2

	ret


DataPalette:
	.ds 16*2

BlackPalette:
	.dw $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000
	.dw $0000,$0000,$0000,$0000,$0000,$0000,$0000,$0000

LogoPalette:
	.dw $0000,$0006,$0205,$0104,$0004,$0005,$0007,$0013
	.dw $0036,$0053,$0777,$0777,$0777,$0777,$0777,$0777

CheckDos2:
	bdos($6f)
	ld a,b
	or a
	ret z

	SetVW(0,0*80)
	ld hl,Dos2.1
	ld c,$98
	ld b,Dos2.1End-Dos2.1
	otir

	SetVW(0,1*80)
	ld hl,Dos2.2
	ld c,$98
	ld b,Dos2.2End-Dos2.2
	otir

	SetVW(0,3*80)
	ld hl,Dos2.3
	ld c,$98
	ld b,Dos2.3End-Dos2.3
	otir

	jp sys.1

Dos2.1:
	.text "SCC Blaffer NT found an DOS2 cartridge in one of your slots..."
Dos2.1End:

Dos2.2:
	.text "SCC Blaffer NT does (yet) not support DOS2..."
Dos2.2End:

Dos2.3:
	.text "So please remove the DOS2 cartridge, and try again... System halted..."
Dos2.3End:


end_program:

.end

; einde.
